<?php
/**
 * Template to display single post content on archive pages
 * Archive Post Style: Mosaic 3 column
 */
?>

<article <?php hoot_attr( 'post', '', 'archive-mosaic archive-mosaic2 hcolumn-1-2' ); ?>>

	<div class="entry-grid hgrid">

		<?php if ( is_sticky() ) : ?>
			<div class="entry-sticky-tag invert-typo"><?php _e( 'Sticky', 'magazine-news-byte-premium' ) ?></div>
		<?php endif; ?>

		<?php $img_size = apply_filters( 'magnb_archive_imgsize', 'hoot-preview-large', 'mosaic2' );
		hoot_post_thumbnail( 'entry-content-featured-img entry-grid-featured-img', $img_size, true, esc_url( get_permalink() ) ); ?>

		<div class="entry-grid-content">

			<header class="entry-header">
				<?php the_title( '<h2 ' . hoot_get_attr( 'entry-title' ) . '><a href="' . esc_url( get_permalink() ) . '" rel="bookmark" itemprop="url">', '</a></h2>' ); ?>
			</header><!-- .entry-header -->

			<?php
			$archive_post_content = hoot_get_mod('archive_post_content');
			if ( 'full-content' == $archive_post_content ) {
				?><div <?php hoot_attr( 'entry-summary', 'content' ); ?>><?php
					the_content();
				?></div><?php
				wp_link_pages();
			} elseif ( 'excerpt' == $archive_post_content ) {
				?><div <?php hoot_attr( 'entry-summary', 'excerpt' ); ?>><?php
					the_excerpt();
				?></div><?php
			}
			?>

			<?php
			$metarray = hoot_get_mod('archive_post_meta');
			if ( hoot_meta_info( $metarray, 'archive-mosaic2', true ) ) :
			?>
			<div class="mosaic-sub">
				<div class="screen-reader-text" itemprop="datePublished" itemtype="https://schema.org/Date"><?php echo get_the_date('Y-m-d'); ?></div>
				<?php hoot_display_meta_info( $metarray, 'archive-mosaic2' ); ?>
			</div><!-- .mosaic-sub -->
			<?php
			endif;
			?>

		</div><!-- .entry-grid-content -->

	</div><!-- .entry-grid -->

</article><!-- .entry -->