<?php
/**
 * Scroller Extension adds Scrollpoints and Waypoints sub-extensions
 *  > sticky-headers (waypoints)
 *  > goto-top buttons (scrollpoints, waypoints optional)
 * 
 * This file is loaded at 'after_setup_theme' hook with 4 priority.
 *
 * @package    Magazine News Byte
 * @subpackage Library Premium
 */

/**
 * Scroller class. This wraps everything up nicely.
 *
 * @since 3.0.0
 */
final class Hoot_Scroller {

	/**
	 * Holds the instance of this class.
	 *
	 * @since 3.0.0
	 * @access private
	 * @var object
	 */
	private static $instance;

	/**
	 * Initialize everything
	 * 
	 * @since 3.0.0
	 * @access public
	 * @return void
	 */
	public function __construct() {

		/* Add the required scripts and styles */
		add_action( 'wp_loaded', array( $this, 'init' ) );

	}

	/**
	 * Initialize everything
	 * 
	 * @since 3.0.0
	 * @access public
	 * @return void
	 */
	public function init() {

		/* Init Support */
		$modules = apply_filters( 'hoot_scroller_modules', array( 'menu-scroll' ) );

		/* Enable Sticky Header */
		if ( in_array( 'sticky-header', $modules ) )
			add_filter( 'hoot_attr_page-wrapper', array( $this, 'hoot_attr_page_wrapper' ), 10, 2 );

		/* Enable Menu Scroll */
		if ( in_array( 'menu-scroll', $modules ) )
			add_filter( 'hoot_attr_menu', array( $this, 'hoot_attr_menu' ), 10, 2 );

		/* Insert Goto Top Button */
		if ( in_array( 'goto-top', $modules ) )
			add_action( 'wp_footer', array( $this, 'goto_top_button' ) );

		/* Add the required scripts and styles */
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_wp_styles_scripts' ) );

	}

	/**
	 * Loads the required stylesheets and scripts
	 *
	 * @since 3.0.0
	 */
	function enqueue_wp_styles_scripts( $hook ) {

		/* Enqueue Waypoint */
		$script_uri = hoot_locate_script( hoot_data()->premium_liburi . 'js/jquery.waypoints' );
		wp_enqueue_script( 'jquery-waypoints', $script_uri, array( 'jquery' ), '4.0.1', true );

		/* Enqueue Waypoint Sticky extension */
		$script_uri = hoot_locate_script( hoot_data()->premium_liburi . 'js/jquery.waypoints.sticky' );
		$waypoint_handle = ( !wp_script_is( 'elementor-waypoints', 'registered' ) ) ? 'jquery-waypoints' : 'elementor-waypoints'; // Sticky attaches to Waypoint followed by elementor loading Waypoint again => this will refresh Waypoint to default (without Sticky). Hence console error "Waypoint.Sticky is not a constructor"
		wp_enqueue_script( 'jquery-waypoints-sticky', $script_uri, array( 'jquery', $waypoint_handle ), '4.0.1', true );

		/* Enqueue Scroller */
		$script_uri = hoot_locate_script( hoot_data()->premium_liburi . 'js/scroller' );
		wp_enqueue_script( 'hoot-scroller', $script_uri, array(), hoot_data()->hoot_version, true );

	}

	/**
	 * Filter Page Wrapper element attributes to enable sticky header
	 *
	 * @since 3.0.0
	 * @access public
	 * @param array $attr
	 * @param string $context
	 * @return array
	 */
	function hoot_attr_page_wrapper( $attr, $context ) {
		$attr['class'] = ( empty( $attr['class'] ) ) ? '' : $attr['class'];
		$attr['class'] .= ' hoot-sticky-header';
		return $attr;
	}

	/**
	 * Filter Page <nav> element attributes to enable scroller to all child <a>
	 *
	 * @since 3.0.0
	 * @access public
	 * @param array $attr
	 * @param string $context
	 * @return array
	 */
	function hoot_attr_menu( $attr, $context ) {
		$attr['class'] = ( empty( $attr['class'] ) ) ? '' : $attr['class'];
		$attr['class'] .= ' scrollpointscontainer';
		return $attr;
	}

	/**
	 * Insert Top Button
	 *
	 * @since 3.0.0
	 */
	function goto_top_button() {
		echo '<a ' . hoot_get_attr( 'goto-top', '', array(
				'href' => '#page-wrapper',
				'class' => 'fixed-goto-top waypoints-goto-top',
				) ) . '><i class="fas fa-chevron-up"></i>' . '</a>';
	}

	/**
	 * Returns the instance.
	 *
	 * @since 3.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		if ( !self::$instance )
			self::$instance = new self;

		return self::$instance;
	}

}

/* Initialize class */
global $hoot_scroller;
$hoot_scroller = Hoot_Scroller::get_instance();