jQuery(document).ready(function($) {
	"use strict";


	/*** Betterbackground Control ***/

	$('.hoot-customize-control-betterbackgroundstart').each(function( index ){

		var $blocks = $(this).nextUntil( '.hoot-customize-control-betterbackgroundend', "li" ),
			$bbButtons = $blocks.filter('.hoot-customize-control-betterbackgroundbutton'),
			$buttons = $bbButtons.find('.hoot-betterbackground-button'),
			$typeInput = $bbButtons.find('input.hoot-customize-control-betterbackground'),
			$customs = $blocks.filter('.customize-control-color, .customize-control-image, .customize-control-select'),
			$predefineds = $blocks.filter('.customize-control-color, .hoot-customize-control-groupstart'),
			showBlocks = function(control){
				if ( control == 'predefined' ) {
					$customs.hide();
					$predefineds.show();
				}
				if ( control == 'custom' ) {
					$predefineds.hide();
					$customs.show();
				}
			};

		$blocks.addClass('hoot-customize-control-background-blocks');//.attr('data-controlbackground', id);

		// If we have both custom image and pattern options
		if ( $bbButtons.length ) {

			$blocks.hide();
			$blocks.filter('.hoot-customize-control-betterbackgroundbutton').show();

			showBlocks( $typeInput.val() );

			$buttons.on('click',function(){
				var value = $(this).data('value');

				$buttons.removeClass('selected').addClass('deactive');
				$(this).removeClass('deactive').addClass('selected');

				$typeInput.val(value).trigger('change');

				showBlocks(value);
			});

		}

		/* Patterns */

		var $pattPreview = $blocks.find('.hoot-betterbackground-button-pattern'),
			$patterns = $blocks.find('.hoot-customize-radioimage');

		if ( $pattPreview.length ) {
			$pattPreview.html('').append( $patterns.filter('.radiocheck').children('img').clone() );

			$patterns.on('click',function(){
				$pattPreview.html('').append( $(this).children('img').clone() );
			});
		}

	});


	/*** Typography Control ***/

	$('.hoot-typo-button').each(function(){

		var $self = $(this),
			controlGroup = $self.data('controlgroup');

		$self.parent('.button.hoot-flypanel-button').addClass('hoot-typo-button-wrap').data('flypanelsubtype', 'typography');

		// Face
		var $face = $self.children('.hoot-typo-button-face');
		if ( $face.length ) {
			var $faceInput = $('#customize-control-' + controlGroup + '-face').find('input');
			$faceInput.on('change',function(){
				$face.html( $faceInput.data( 'label' ) );
			});
			$face.html( $faceInput.data( 'label' ) );
		}

		// Size
		var $size = $self.children('.hoot-typo-button-size');
		if ( $size.length ) {
			var $sizeInput = $('#customize-control-' + controlGroup + '-size').find('select');
			$sizeInput.on('change',function(){
				$size.html( $sizeInput.val() );
			});
			$size.html( $sizeInput.val() );
		}

		// Style
		var $style = $self.children('.hoot-typo-button-style');
		if ( $style.length ) {
			var $styleInput = $('#customize-control-' + controlGroup + '-style').find('select');
			$styleInput.on('change',function(){
				$style.attr( 'data-style', $styleInput.val() );
			});
			$style.attr( 'data-style', $styleInput.val() );
		}

		// Color
		var $color = $self.children('.hoot-typo-button-color');
		if ( $color.length ) {

			// var $colorInput = $('#customize-control-' + controlGroup + '-color').find('input.color-picker-hex');
			// $colorInput.on('change',function(){ //change event is not triggered on $colorInput by the ColorPicker api
			// 	$color.css( 'background-color', $colorInput.val() );
			// });
			// $color.css( 'background-color', $colorInput.val() );

			// var $colorPicker = $('#customize-control-' + controlGroup + '-color').find('.wp-picker-container'),
			// 	$colorResult = $colorPicker.children('.wp-color-result');
			// $colorPicker.on('click',function(){ // This gets binded before ColorPicker api updates bg color
			// 	$color.css( 'background-color', $colorResult.css('background-color') );
			// })
			// $color.css( 'background-color', $colorResult.css('background-color') );

			var $colorPicker = $('#customize-control-' + controlGroup + '-color').find('.wp-picker-container'),
				$colorInput = $('#customize-control-' + controlGroup + '-color').find('input.color-picker-hex');
			$colorPicker.on('mouseenter mouseleave mousemove',function(){
				$color.css( 'background-color', $colorInput.val() );
			});
			$color.css( 'background-color', $colorInput.val() );

		}

	});

	/** Fontface Picker **/

	$('.hoot-fontface-list').each(function(){

		var $self = $(this),
			$pickedSelect = $self.siblings('.hoot-customize-control-fontface-picked'),
			$picked = $pickedSelect.children('div'),
			$input = $self.siblings('input.hoot-customize-control-fontface'),
			$fontfaces = $self.children('.hoot-fontface-listitem ');

		$pickedSelect.on('click',function(){
			$(this).toggleClass('active');
			$self.toggle();
		});

		$fontfaces.on('click',function(){
			$fontfaces.removeClass('selected');
			$(this).addClass('selected');
			$pickedSelect.removeClass('active');
			$self.hide();
			$input.val( $(this).data('value') ).data( 'label', $(this).data('label') ).trigger('change');
			$picked.html( $(this).data('label') );
		});

	});

	/** Close Fontface Picker **/

	var $fontfaceLists = $('.hoot-fontface-list'),
		$pickedSelects = $('.hoot-customize-control-fontface-picked');

	// Add .hoot-flypanel also as hoot-flypanel has event.stopPropagation() on click
	$('body, .hoot-flypanel').click( function(event){
		if ( ! $(event.target).closest('.customize-control-fontface').length ) {
			$fontfaceLists.hide();
			$pickedSelects.removeClass('active');
		}
	});


});