<?php
/**
 * Customize for typography, extend the WP customizer
 *
 * @package    Magazine News Byte
 * @subpackage Library Premium
 */

/**
 * Fontface Control Class extends the WP customizer
 *
 * @since 3.0.0
 */
// Only load in customizer (not in frontend)
if ( class_exists( 'WP_Customize_Control' ) ) :
class Hoot_Customize_Fontface_Control extends WP_Customize_Control {

	/**
	 * @since 3.0.0
	 * @access public
	 * @var string
	 */
	public $type = 'fontface';

	/**
	 * Render the control's content.
	 * Allows the content to be overriden without having to rewrite the wrapper.
	 *
	 * @since 3.0.0
	 * @return void
	 */
	public function render_content() {

		switch ( $this->type ) {

			case 'fontface' :

				if ( ! empty( $this->label ) ) : ?>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<?php endif;

				if ( ! empty( $this->description ) ) : ?>
					<span class="description customize-control-description"><?php echo wp_kses_post( $this->description ) ; ?></span>
				<?php endif;

				$value = $this->value();
				$webfonts = hoot_enum_font_faces('websafe');
				$googlefonts = hoot_enum_font_faces('google-fonts');
				$selectedfont = ( isset( $webfonts[ $value ] ) ) ?
							$webfonts[ $value ] :
							(
								( isset( $googlefonts[ $value ] ) ) ?
								$googlefonts[ $value ] :
								''
							);
				?>

				<input class="hoot-customize-control-fontface" value="<?php echo esc_attr( $value ) ?>" <?php $this->link(); ?> type="hidden" data-label="<?php echo esc_attr( $selectedfont ); ?>"/>

				<div class="hoot-customize-control-fontface-picked">
					<div><?php echo $selectedfont; ?></div>
				</div>

				<div class="hoot-fontface-list">
					<?php $fontclass = ' hoot-fontface-websafe';

					// Allow child themes to add custom fonts
					do_action( 'hoot_fontface_list', $value );

					foreach ( array(
						__( 'Websafe Fonts', 'magazine-news-byte-premium' ) => $webfonts,
						__( 'Google Web Fonts', 'magazine-news-byte-premium' ) => $googlefonts,
						) as $subhead => $fontarray ) {

						$font_count = 0;
						?>
						<h4><?php echo $subhead; ?></h4>
						<?php

						foreach ( $fontarray as $val => $label ) {
							$selected = ( $val == $value ) ? ' selected' : '';
							?>
							<div class="hoot-fontface-listitem <?php echo $selected; ?>" data-value="<?php echo esc_attr( $val ) ?>" data-label="<?php echo esc_attr( $label ) ?>">
								<span><?php echo esc_html( $label ); ?></span>
								<div class="hoot-fontface-preview<?php echo $fontclass; ?>" style="background-position: 0 <?php echo ( -30 * $font_count ) .'px;'; ?>"></div>
							</div>
							<?php
							$font_count++;
						}

						$fontclass = '';
					}
					?>

				</div>

				<?php
				break;

		}

	}

}
endif;

/**
 * Hook into control display interface
 *
 * @since 3.0.0
 * @param object $wp_customize
 * @param string $id
 * @param array $setting
 * @return void
 */
// Only load in customizer (not in frontend)
if ( class_exists( 'WP_Customize_Control' ) ) :
function hoot_customize_fontface_control_interface ( $wp_customize, $id, $setting ) {
	if ( isset( $setting['type'] ) ) :
		if ( $setting['type'] == 'fontface' ) {
			$wp_customize->add_control(
				new Hoot_Customize_Fontface_Control( $wp_customize, $id, $setting )
			);
		}
	endif;
}
add_action( 'hoot_customize_control_interface', 'hoot_customize_fontface_control_interface', 10, 3 );
endif;

/**
 * Modify the settings array and prepare typography settings for Customizer Library Interface functions
 *
 * @since 3.0.0
 * @param array $value
 * @param string $key
 * @param array $setting
 * @param int $count
 * @return void
 */
function hoot_customize_prepare_typography_settings( $value, $key, $setting, $count ) {

	if ( $setting['type'] == 'typography' ) {

		$setting = wp_parse_args( $setting, array(
			'label'       => '',
			'sublabel'    => '',
			'section'     => '',
			'priority'    => '',
			'description' => '',
			'startwrap'   => '',
			// 'button'      => '',
			'choices'     => array(),
			'default'     => array(),
			'options'     => array( 'size', 'face', 'style', 'color' ),
			'identifier'  => $key,
			) );
		$setting['choices'] = wp_parse_args( $setting['choices'], array(
			'size'        => array(),
			'face'        => array(),
			'style'       => array(),
			) );
		$setting['default'] = wp_parse_args( $setting['default'], array(
			'size'        => '',
			'face'        => '',
			'style'       => '',
			'color'       => '',
			) );

		if( is_array( $setting['options'] ) && !empty( $setting['options'] ) ):
			$size = in_array( 'size', $setting['options'] );
			$face = in_array( 'face', $setting['options'] );
			$style = in_array( 'style', $setting['options'] );
			$color = in_array( 'color', $setting['options'] );

			if( $size || $face || $style || $color ):

				// Group Start
				$button = "<span class='hoot-typo-button' data-controlgroup='{$key}'>";
					if ( $face ) $button .= '<span class="hoot-typo-button-unit hoot-typo-button-face"></span>';
					if ( $size ) $button .= '<span class="hoot-typo-button-unit hoot-typo-button-size"></span>';
					if ( $style ) $button .= '<span class="hoot-typo-button-unit hoot-typo-button-style"></span>';
					if ( $color ) $button .= '<span class="hoot-typo-button-unit hoot-typo-button-color"></span>';
				$button .= '</span>';

				$value[ "group-{$count}" ] = array(
					'label'       => $setting['label'],
					'sublabel'    => $setting['sublabel'],
					'section'     => $setting['section'],
					'type'        => 'group',
					'priority'    => $setting['priority'],
					'description' => $setting['description'],
					'startwrap'   => $setting['startwrap'],
					'button'      => $button,
					'identifier'  => $setting['identifier'],
					'group'       => 'start',
				);

				// Font Color :: (priority & section same as group)
				if ( $color ) :

					$value[ "{$key}-color" ] = array(
						'label'       =>  __( 'Font Color', 'magazine-news-byte-premium' ),
						'section'     => $setting['section'],
						'type'        => 'color',
						'priority'    => $setting['priority'],
						'default'     => $setting['default']['color'],
						'description' => '',
					);

				endif;

				// Font Size :: (priority & section same as group)
				if ( $size ) :

					$choices = array();
					$fontsizes = ( !empty( $setting['choices']['size'] ) && is_array( $setting['choices']['size'] ) ) ?
						$setting['choices']['size'] : hoot_enum_font_sizes();
					foreach ( $fontsizes as $fsz )
						$choices[ $fsz . 'px' ] = $fsz . 'px';

					$value[ "{$key}-size" ] = array(
						'label'       =>  __( 'Font Size', 'magazine-news-byte-premium' ),
						'section'     => $setting['section'],
						'type'        => 'select',
						'priority'    => $setting['priority'],
						'choices'     => $choices,
						'default'     => $setting['default']['size'],
						'description' => '',
					);

				endif;

				// Font Style :: (priority & section same as group)
				if ( $style ):

					$choices = ( !empty( $setting['choices']['style'] ) && is_array( $setting['choices']['style'] ) ) ?
						$setting['choices']['style'] : hoot_enum_font_styles();

					$value[ "{$key}-style" ] = array(
						'label'       =>  __( 'Font Style', 'magazine-news-byte-premium' ),
						'section'     => $setting['section'],
						'type'        => 'select',
						'priority'    => $setting['priority'],
						'choices'     => $choices,
						'default'     => $setting['default']['style'],
						'description' => array(
							'type' => 'blue',
							'text' => sprintf( __( 'NOTE: Not all fonts support all styles/variants. For example, "Playball" font does not support Bold/Italic/Light variant.<hr />For more info, check the %1$sGoogle Fonts Library%2$s', 'magazine-news-byte-premium' ), '<a href="https://www.google.com/fonts">', '</a>'),
						),
					);

				endif;

				// Font Face :: (priority & section same as group)
				if ( $face ):

					$value[ "{$key}-face" ] = array(
						'label'       =>  __( 'Font Face', 'magazine-news-byte-premium' ),
						'section'     => $setting['section'],
						'type'        => 'fontface',
						'priority'    => $setting['priority'],
						'choices'     => $setting['choices']['face'],
						'default'     => $setting['default']['face'],
						'description' => '',
					);

				endif;

				// Group End
				$value[ "group-{$count}-end" ] = array(
					'section'     => $setting['section'],
					'type'        => 'group',
					'priority'    => $setting['priority'],
					'group'       => 'end',
				);

			endif;
		endif;

	}

	return $value;

}
add_filter( 'hoot_customize_prepare_settings', 'hoot_customize_prepare_typography_settings', 10, 4 );

/**
 * Add sanitization function
 *
 * @since 3.0.0
 * @param string $callback
 * @param string $type
 * @param array $setting
 * @param string $name name (id) of the setting
 * @return string
 */
function hoot_customize_sanitize_fontface_callback( $callback, $type, $setting, $name ) {
	if ( $type == 'fontface' )
		$callback = 'hoot_sanitize_fontface';
	return $callback;
}
add_filter( 'hoot_customize_sanitize_callback', 'hoot_customize_sanitize_fontface_callback', 5, 4 );