<?php
/**
 * Hook into several library functions from core theme
 *
 * @package    Magazine News Byte
 * @subpackage Library Premium
 */

/* == locations == */

/**
 * Add premium archive post template locations
 *
 * @since 3.0.0
 * @param array $templates
 * @param string $name
 * @param string $post_type
 * @return array
 */
function hoot_premium_archive_post_template_hierarchy( $templates, $name, $post_type ) {

	$base_premium = str_replace( hoot_data()->template_dir, '', hoot_data()->template_premium_dir );

	// Lets rebuild the locations
	$templates = array();

	if ( '' !== $name ) {
		$templates[] = $base_premium . "archive-{$post_type}-{$name}.php"; // Not recommended in theme to allow easy child theme customization
		$templates[] = "archive-{$post_type}-{$name}.php";                 // Not recommended in theme to allow easy child theme customization
		$templates[] = $base_premium . "template-parts/archive-{$post_type}-{$name}.php";
		$templates[] = "template-parts/archive-{$post_type}-{$name}.php";
		$templates[] = $base_premium . "archive-{$name}.php";              // Not recommended in theme to allow easy child theme customization
		$templates[] = "archive-{$name}.php";                              // Not recommended in theme to allow easy child theme customization
		$templates[] = $base_premium . "template-parts/archive-{$name}.php";
		$templates[] = "template-parts/archive-{$name}.php";
	}

	$templates[] = $base_premium . "archive-{$post_type}.php";             // Not recommended in theme to allow easy child theme customization
	$templates[] = "archive-{$post_type}.php";                             // Not recommended in theme to allow easy child theme customization
	$templates[] = $base_premium . "template-parts/archive-{$post_type}.php";
	$templates[] = "template-parts/archive-{$post_type}.php";
	// $templates[] = $base_premium . 'archive.php';                       // for brevity
	// $templates[] = 'archive.php';                                       // conflict
	// $templates[] = $base_premium . 'template-parts/archive.php';        // for brevity
	// $templates[] = 'template-parts/archive.php';                        // for brevity

	return $templates;
}
add_filter( 'hoot_archive_post_template_hierarchy', 'hoot_premium_archive_post_template_hierarchy', 5, 3 );

/**
 * Add premium widget template locations
 *
 * @since 3.0.0
 * @param array $templates
 * @param string $name
 * @return array
 */
function hoot_premium_widget_template_hierarchy( $templates, $name ) {

	$base_premium = str_replace( hoot_data()->template_dir, '', hoot_data()->template_premium_dir );

	// Lets rebuild the locations
	$templates = array();

	// For theme 2.9.0 users who havent updated to HootKit 1.1.0
	$name = ( $name == 'slider-postlistcarousel' ) ? 'slider-verticalcarousel' : $name;

	if ( '' !== $name ) {
		$templates[] = $base_premium . "widget-{$name}.php"; // Not recommended in theme to allow easy child theme customization
		$templates[] = "widget-{$name}.php";                 // Not recommended in theme to allow easy child theme customization
		$templates[] = $base_premium . "hootkit/widget-{$name}.php";
		$templates[] = "hootkit/widget-{$name}.php";
		$templates[] = $base_premium . "template-parts/widget-{$name}.php";
		$templates[] = "template-parts/widget-{$name}.php";
	}

	$templates[] = $base_premium . 'widget.php';             // Not recommended in theme to allow easy child theme customization
	$templates[] = 'widget.php';                             // Not recommended in theme to allow easy child theme customization
	$templates[] = $base_premium . 'hootkit/widget.php';
	$templates[] = 'hootkit/widget.php';
	$templates[] = $base_premium . 'template-parts/widget.php';
	$templates[] = 'template-parts/widget.php';

	return $templates;
}
add_filter( 'hoot_widget_template_hierarchy', 'hoot_premium_widget_template_hierarchy', 5, 2 );


/* == utility == */


/**
 * Helper function for getting the minified script/style uri if available.
 *
 * @since 3.0.0
 * @access public
 * @param array $locations
 * @param string $location
 * @param string $type
 * @param bool $loadminified
 * @return array
 */
function hoot_premium_locate_uri( $locations, $location, $type, $loadminified ) {

	/** Rewrite Locations **/

	$locations = array();
	if ( is_child_theme() ) {

		if ( $loadminified )
			$locations['child-premium-min'] = array(
				'path' => hoot_data()->child_dir . 'premium/' . $location . '.min.' . $type,
				'uri'  => hoot_data()->child_uri . 'premium/' . $location . '.min.' . $type,
				);

		$locations['child-premium'] = array(
			'path' => hoot_data()->child_dir . 'premium/' . $location . '.' . $type,
			'uri'  => hoot_data()->child_uri . 'premium/' . $location . '.' . $type,
			);

		if ( $loadminified )
			$locations['child-default-min'] = array(
				'path' => hoot_data()->child_dir . $location . '.min.' . $type,
				'uri'  => hoot_data()->child_uri . $location . '.min.' . $type,
				);

		$locations['child-default'] = array(
			'path' => hoot_data()->child_dir . $location . '.' . $type,
			'uri'  => hoot_data()->child_uri . $location . '.' . $type,
			);

	}

	if ( $loadminified )
		$locations['premium-min'] = array(
			'path' => hoot_data()->template_dir . 'premium/' . $location . '.min.' . $type,
			'uri'  => hoot_data()->template_uri . 'premium/' . $location . '.min.' . $type,
			);

	$locations['premium'] = array(
		'path' => hoot_data()->template_dir . 'premium/' . $location . '.' . $type,
		'uri'  => hoot_data()->template_uri . 'premium/' . $location . '.' . $type,
		);

	if ( $loadminified )
		$locations['default-min'] = array(
			'path' => hoot_data()->template_dir . $location . '.min.' . $type,
			'uri'  => hoot_data()->template_uri . $location . '.min.' . $type,
			);

	$locations['default'] = array(
		'path' => hoot_data()->template_dir . $location . '.' . $type,
		'uri'  => hoot_data()->template_uri . $location . '.' . $type,
		);

	return $locations;

}
add_filter( 'hoot_locate_uri', 'hoot_premium_locate_uri', 5, 4 );