<?php
/**
 * HTML attribute filters.
 * Filter schema ('library/attr-schema.php') for generic container's attributes based on specific theme options
 * Attributes for non-generic structural elements (mostly theme specific) are also loaded in this file.
 *
 * @package    Magazine News Byte
 * @subpackage Theme Premium
 */

/* Modify Original Schema for Generic container's Option specific attributes */
add_filter( 'hoot_attr_content', 'magnb_attr_premium_content', 9 );

/* New Theme Filters */

/* Modify New Theme Filters from Core Theme */
add_filter( 'hoot_attr_loop-meta-wrap', 'magnb_attr_premium_loop_meta_wrap', 9, 2 );

/**
 * Modify Main content container of the page attributes.
 *
 * @since 1.0
 * @access public
 * @param array $attr
 * @return array
 */
function magnb_attr_premium_content( $attr ) {
	$attr['class'] = ( empty( $attr['class'] ) ) ? '' : $attr['class'];

	if ( is_404() && 'custom' == hoot_get_mod('404_page') )
		$attr['class'] .= ' custom-404-content';

	return $attr;
}

/**
 * Loop meta attributes.
 *
 * @since 1.0
 * @param array $attr
 * @param string $context
 * @return array
 */
function magnb_attr_premium_loop_meta_wrap( $attr, $context ) {
	$attr['id'] = 'loop-meta';
	$attr['class'] = ( empty( $attr['class'] ) ) ? '' : $attr['class'];

	/* Overwrite free versions default class pageheader-bg-default */
	$background = hoot_get_mod( 'pageheader_background_location' );
	if ( empty( $background ) )
		$background = 'stretch';
	$attr['class'] = " loop-meta-wrap pageheader-bg-{$background}";

	return $attr;
}