<?php
/* Let developers alter slider via global $hoot_data */
do_action( 'hootkit_widgetcarousel_start', ( ( !isset( $instance ) ) ? array() : $instance ) );

/* Get Slider Data */
$slider = hoot_data( 'slider' );
if ( empty( $slider ) || !is_array( $slider ) )
	return;
$slidersettings = hoot_data( 'slidersettings' );
$slidersettings = ( empty( $slidersettings ) || !is_array( $slidersettings ) ) ? array() : $slidersettings;
$slidersettings['type'] = ( empty( $slidersettings['type'] ) ) ? '' : $slidersettings['type'];

/* Widget Class & Style */
$widgetclass = '';
if ( isset( $slidersettings['widgetclass'] ) ) {
	$widgetclass .= ' ' . hoot_sanitize_html_classes( $slidersettings['widgetclass'] );
	unset( $slidersettings['widgetclass'] );
}
$widgetstyle = '';
if ( isset( $slidersettings['widgetstyle'] ) ) {
	$widgetstyle .= 'style="' . esc_attr( $slidersettings['widgetstyle'] ) . '"';
	unset( $slidersettings['widgetstyle'] );
}
/* Add vertical class : needed for css , and for js to add function to slider arrows */
$widgetclass .= ( $slidersettings['vertical'] == 'true' ) ? ' lightSliderVertical' : '';
/* Set Style */
$widgetclass .= ' verticalcarousel-' . $style;

/* Manage Navigation */
$widgetclass .= ' hidearrows hidebullets';
$nav = ( !empty( $nav ) ) ? $nav : '';

/* Vertical units */
if ( !empty( $slidersettings['verticalunits'] ) ) {
	extract( $slidersettings['verticalunits'] );
	unset( $slidersettings['verticalunits'] );
}

/* Create Data attributes for javascript settings for this slider */
$atts = $class = '';
if ( isset( $slidersettings['id'] ) ) {
	$atts .= ' id="' . sanitize_html_class( $slidersettings['id'] ) . '"';
	unset( $slidersettings['id'] );
}
if ( isset( $slidersettings['class'] ) ) {
	$class .= ' ' . hoot_sanitize_html_classes( $slidersettings['class'] );
	unset( $slidersettings['class'] );
}
if ( isset( $slidersettings['item'] ) ) {
	$class .= ( $slidersettings['item'] == 1 ) ? ' singleSlideView' : ' multiSlideView';
}
foreach ( $slidersettings as $setting => $value )
	$atts .= ' data-' . sanitize_html_class( $setting ) . '="' . esc_attr( $value ) . '"';

/* Start Slider Template */
$slide_count = 1;

// Set vars
$subtitle = ( !empty( $subtitle ) ) ? $subtitle : '';
$viewall = ( !empty( $viewall ) ) ? $viewall : '';

?>
<div class="verticalcarousel-widget<?php echo $widgetclass; ?>" <?php echo $widgetstyle ?>>

	<?php
	/* Display Title */
	$titlemarkup = $titleclass = '';
	if ( !empty( $title ) ) {
		$titlemarkup .= $before_title . $title . $after_title;
		$titleclass .= ' hastitle';
	}
	if ( $viewall == 'top' ) {
		$titleclass .= ' hasviewall';
		if ( $slidersettings['type'] == 'postlistcarousel' )
			$titlemarkup .= ( function_exists( 'hootkit_get_viewall' ) ) ? hootkit_get_viewall() : '';
		if ( $slidersettings['type'] == 'productlistcarousel' )
			$titlemarkup .= ( function_exists( 'hootkit_get_viewall' ) ) ? hootkit_get_viewall( false, 'product' ) : '';
	}
	if ( $nav == 'arrows' ) {
		$titlemarkup .= '<div class="lSAction"><a class="lSPrev"></a><a class="lSNext"></a></div>';
		$titleclass .= ' hasnav';
	}
	$titlemarkup = ( !empty( $titlemarkup ) ) ? '<div class="widget-title-wrap' . $titleclass . '">' . $titlemarkup . '</div>' : '';
	$titlemarkup .= ( !empty( $subtitle ) ) ? '<div class="widget-subtitle hoot-subtitle">' . $subtitle . '</div>' : '';
	echo do_shortcode( wp_kses_post( apply_filters( 'hootkit_widget_title', $titlemarkup, 'verticalcarousel', $title, $before_title, $after_title, $subtitle, $viewall, $nav ) ) );

	// Template modification Hook
	do_action( 'hootkit_carousel_start', $slidersettings['type'], ( ( !isset( $instance ) ) ? array() : $instance ) );
	?>

	<ul class="lightSlider<?php echo $class; ?>"<?php echo $atts; ?>><?php
		foreach ( $slider as $key => $slide ) :

			$slide = wp_parse_args( $slide, array(
				'image'      => '',
				'title'      => '',
				'url'        => '',
				'meta'       => '',
			) );
			$slide['image'] = intval( $slide['image'] );
			?>

			<li class="lightSlide verticalcarousel-slide verticalcarousel-slide-<?php echo $slide_count; $slide_count++; ?>">
				<div class="verticalcarousel" style="height:<?php echo intval(${'height'.$style}); ?>px;margin-bottom:<?php echo intval($unitmargin); ?>px;">

					<?php
					$img_attr = array( 'class' => 'verticalcarousel-img', 'style' => '' );
					$img_attr['class'] .= ( !empty( $slide['image'] ) ) ? ' verticalcarousel-hasimg' : ' verticalcarousel-noimg';
					if ( !empty( $slide['image'] ) ) :
						$img_size = ( $style == 'style1' ) ? 'hoot-preview-thumb' : 'hoot-preview-large';
						$img_size = apply_filters( 'verticalcarousel_imgsize', $img_size, $style );
						$isrc = wp_get_attachment_image_src( $slide['image'], $img_size );
						if( empty( $isrc ) ) $isrc = wp_get_attachment_image_src( $slide['image'], $img_size, true );
						if ( !empty( $isrc[0] ) )
							$img_attr['style'] = 'background-image:url(' . esc_url($isrc[0]) . ');';
					endif;
					$img_attr['style'] .= 'height:' . intval(${'height'.$style}) . 'px;';
					if ( $style == 'style1' ) $img_attr['style'] .= 'width:' . ( intval(${'height'.$style}) + 10 ) . 'px;';
					?>

					<div <?php echo hoot_get_attr( 'verticalcarousel-img', '', $img_attr ) ?>>
						<div class="<?php if ( $style == 'style2' ) echo 'verticalcarousel-gradient'; else echo 'verticalcarousel-nogradient'; ?>">
							<?php echo '<a href="' . esc_url( $slide['url'] ) . '" ' . hoot_get_attr( 'verticalcarousel-imglink', 'permalink' ) . '></a>'; ?>
						</div>
					</div>

					<div <?php hoot_attr( 'verticalcarousel-content' ) ?>>
						<?php if ( !empty( $slide['meta_cats'] ) ) echo $slide['meta_cats']; ?>
						<h4 class="verticalcarousel-title"><?php echo wp_kses_post( $slide['title'] ); ?></h4>
						<?php if ( !empty( $slide['meta'] ) ) echo $slide['meta']; ?>
						<?php if ( !empty( $slide['caption'] ) ) echo '<div class="verticalcarousel-text">' . wp_kses_post( wpautop( $slide['caption'] ) ) . '</div>'; ?>
					</div>

				</div>
			</li>
			<?php
		endforeach;
		?>
	</ul>

	<?php
	// View All link
	if ( $viewall == 'bottom' ) {
		if ( $slidersettings['type'] == 'postlistcarousel' )
			$titlemarkup .= ( function_exists( 'hootkit_get_viewall' ) ) ? hootkit_get_viewall( true ) : '';
		if ( $slidersettings['type'] == 'productlistcarousel' )
			$titlemarkup .= ( function_exists( 'hootkit_get_viewall' ) ) ? hootkit_get_viewall( true, 'product' ) : '';
	}

	// Template modification Hook
	do_action( 'hootkit_carousel_end', $slidersettings['type'], ( ( !isset( $instance ) ) ? array() : $instance ) );
	?>

</div>