<?php
// Return if no content to show
if ( empty( $title ) && empty( $content ) )
	return;

// Set Styles
$inlinestyle = $styleclass = '';
if ( $background || $fontcolor ) {
	$styleclass = 'noticewidget-userstyle';
	$inlinestyle = ' style="';
	$inlinestyle .= ( $background ) ? ' background:' . sanitize_hex_color( $background ) . ';' : '';
	$inlinestyle .= ( $fontcolor ) ? ' color:' . sanitize_hex_color( $fontcolor ) . ';' : '';
	$inlinestyle .= '" ';
}

// Set Preset
switch ( $preset ) {
	case 'success':	$boxicon = 'fa-check fas';
					$scheme = 'green';
					break;
	case 'warning':	$boxicon = 'fa-exclamation-triangle fas';
					$scheme = 'orange';
					break;
	case 'error':	$boxicon = 'fa-times fas';
					$scheme = 'red';
					break;
	case 'info':	$boxicon = 'fa-info-circle fas';
					$scheme = 'blue';
					break;
	case 'note':	$boxicon = 'fa-pencil-alt fas';
					$scheme = 'yellow';
					break;
	case 'flag':	$boxicon = 'fa-flag fas';
					$scheme = 'amber';
					break;
	case 'pushpin':	$boxicon = 'fa-thumbtack fas';
					$scheme = 'cyan';
					break;
	case 'setting':	$boxicon = 'fa-cog fas';
					$scheme = 'white';
					break;
	default:		$boxicon = '';
					$scheme = $preset;
}

// Set Icon
$boxicon = ( !empty( $icon ) ) ? $icon : $boxicon;
if ( !empty( $iconcolor ) ) {
	$iconstyleclass = 'noticewidget-icon-userstyle';
	$iconinlinestyle = ' style="';
	$iconinlinestyle .= ( $iconcolor ) ? 'color:' . sanitize_hex_color( $iconcolor ) . ';' : '';
	$iconinlinestyle .= '" ';
} else $iconinlinestyle = $iconstyleclass = '';
?>

<div class="notice-widget-wrap notice-<?php echo $preset; ?>">
	<div class="notice-widget preset-<?php echo $scheme ?> <?php echo $styleclass; ?> table" <?php echo $inlinestyle;?>>
		<?php

		if ( !empty( $boxicon ) ) {
			?><div class="notice-icon notice-icon<?php echo $iconsize ?> table-cell-mid">
				<i class="<?php echo hoot_sanitize_fa( $boxicon ) . ' ' . $iconstyleclass ?>" <?php echo $iconinlinestyle; ?>></i>
			</div><?php
		}

		if ( !empty( $title ) || !empty( $content ) ) {
			?><div class="notice-content table-cell-mid"><?php
				if ( !empty( $title ) ) echo wp_kses_post( '<h6 class="notice-title">' . $title . '</h6>' );
				if ( !empty( $subtitle ) ) echo '<div class="hoot-subtitle">' . do_shortcode( wp_kses_post( $subtitle ) ) . '</div>';
				if ( !empty( $content ) ) echo '<div class="notice-text">' . do_shortcode( wp_kses_post( wpautop( $content ) ) ) . '</div>';
			?></div><?php
		}

		?>
	</div>
</div>