<?php
/**
 * This file contains functions and hooks for styling Hootkit plugin
 *   Hootkit is a free plugin released under GPL license and hosted on wordpress.org.
 *   It is recommended to the user via wp-admin using TGMPA class
 *
 * This file is loaded at 'after_setup_theme' action @priority 10 ONLY IF hootkit plugin is active
 *
 * @package    Magazine News Byte
 * @subpackage HootKit
 */

// Register HootKit
add_filter( 'hootkit_register', 'magnb_premium_register_hootkit', 7 );

// Add dynamic CSS for hootkit
add_action( 'hoot_dynamic_cssrules', 'magnb_premium_hootkit_dynamic_cssrules', 7 );

// Load theme's Hootkit options
include_once( hoot_data()->template_premium_dir . 'hootkit/options.php' );

/**
 * Register Hootkit
 *
 * @since 1.0
 * @param array $config
 * @return string
 */
if ( !function_exists( 'magnb_premium_register_hootkit' ) ) :
function magnb_premium_register_hootkit( $config ) {
	$sliders = array( 'carousel', 'postcarousel', 'postlistcarousel' );
	$widgets = array( 'contact-info', 'number-blocks', 'vcards', 'buttons', 'icon-list', 'notice', 'toggle', 'tabs', );
	if ( is_array( $config ) ) {
		// @deprecated <= HootKit v1.2.0 @10.20 // @deprecated <= HootKit v2.0.3 @6.21
		if ( !empty( $config['modules'] ) && is_array( $config['modules'] ) ) {
			$config['modules']['sliders'] = ( !empty( $config['modules']['sliders'] ) && is_array( $config['modules']['sliders'] ) ) ? $config['modules']['sliders'] : array();
			$config['modules']['widgets'] = ( !empty( $config['modules']['widgets'] ) && is_array( $config['modules']['widgets'] ) ) ? $config['modules']['widgets'] : array();
		} else $config['modules']['sliders'] = $config['modules']['widgets'] = array();
		$config['modules']['sliders'] = array_merge( $config['modules']['sliders'], $sliders );
		$config['modules']['widgets'] = array_merge( $config['modules']['widgets'], $widgets );
	}
	if ( !empty( $config['premium'] ) ) unset( $config['premium'] );

	return $config;
}
endif;

/**
 * Custom CSS built from user theme options for hootkit features
 * For proper sanitization, always use functions from library/sanitization.php
 *
 * @since 1.0
 * @access public
 */
if ( !function_exists( 'magnb_premium_hootkit_dynamic_cssrules' ) ) :
function magnb_premium_hootkit_dynamic_cssrules() {

	// Get user based style values
	$styles = magnb_user_style();
	extract( $styles );

	/*** Add Dynamic CSS ***/

	hoot_add_css_rule( array(
						'selector'  => '.flycart-toggle, .flycart-panel',
						'property'  => 'color',
						'value'     => $font_body_color,
						'idtag'     => 'font_body_color',
				) );

	/* Sliders */

	hoot_add_css_rule( array(
						'selector'  => '.hootkitslide-caption h1, .hootkitslide-caption h2, .hootkitslide-caption h3, .hootkitslide-caption h4, .hootkitslide-caption h5, .hootkitslide-caption h6',
						'property'  => 'font-size',
						'value'     => $font_h3_size,
						'idtag'     => 'font_h3-size',
					) );

	hoot_add_css_rule( array(
						'selector'  => '.hootkitcarousel-content h1, .hootkitcarousel-content h2, .hootkitcarousel-content h3, .hootkitcarousel-content h4, .hootkitcarousel-content h5, .hootkitcarousel-content h6',
						'property'  => 'font-size',
						'value'     => $font_h5_size,
						'idtag'     => 'font_h5-size',
					) );

	// hoot_add_css_rule( array(
	// 					'selector'  => '.hootslider-carousel-slide-content .more-link a',
	// 					'property'  => 'color',
	// 					'value'     => $link_color,
	// 					'idtag'     => 'link_color',
	// 				) );

	/* Sidebars and Widgets */

	hoot_add_css_rule( array(
						'selector'  => '.widget .view-all a' . ',' . // @deprecated <= HootKit v1.1.0 @5.20 view-all
									   '.widget .viewall a',
						'property'  => 'color',
						'value'     => $font_body_light,
					) );

	// @deprecated <= HootKit v1.1.0 @5.20 view-all
	hoot_add_css_rule( array(
						'selector'  => '.widget .view-all a:hover',
						'property'  => 'color',
						'value'     => $link_color,
						'idtag'     => 'link_color',
					) ); // Overriding non premium dynamic css

	hoot_add_css_rule( array(
						'selector'         => '.content-block-title' . ',' . '.hk-listunit-title' . ',' . '.verticalcarousel-title',
						'property'         => 'typography',
						'idtag'            => 'font_h5',
						'typography_reset' => true,
					) );

	// hoot_add_css_rule( array(
	// 					'selector'  => '.content-block-subtitle',
	// 					'property'  => 'color',
	// 					'value'     => $font_h4_color,
	// 					'idtag'     => 'font_h4-color',
	// 				) );

	// hoot_add_css_rule( array(
	// 					'selector'  => '.hk-list-style2 .hk-listunit-small .hk-listunit-title',
	// 					'property'  => 'font-size',
	// 					'value'     => $font_h6_size,
	// 					'idtag'     => 'font_h6-size',
	// 				) );

	hoot_add_css_rule( array(
						'selector'  => '.vcard-content h4, .vcard-content h1, .vcard-content h2, .vcard-content h3, .vcard-content h5, .vcard-content h6',
						'property'  => 'font-size',
						'value'     => $font_h6_size,
						'idtag'     => 'font_h6-size',
					) );

	// hoot_add_css_rule( array(
	// 					'selector'  => '.vcard-content cite',
	// 					'property'  => 'color',
	// 					'value'     => $font_h4_color,
	// 					'idtag'     => 'font_h4-color',
	// 				) );

	// hoot_add_css_rule( array(
	// 					'selector'  => '.vcard-content > p:last-child > a:last-child',
	// 					'property'  => array(
	// 						// property  => array( value, idtag, important, typography_reset ),
	// 						'background' => array( $accent_color, 'accent_color' ),
	// 						'color'      => array( $accent_font, 'accent_font' ),
	// 						),
	// 				) );

	hoot_add_css_rule( array(
						'selector'  => '.number-block-content h4, .number-block-content h1, .number-block-content h2, .number-block-content h3, .number-block-content h5, .number-block-content h6',
						'property'  => 'font-size',
						'value'     => $font_h6_size,
						'idtag'     => 'font_h6-size',
					) );

	// hoot_add_css_rule( array(
	// 					'selector'  => '.number-block-content > p:last-child > a:last-child',
	// 					'property'  => array(
	// 						// property  => array( value, idtag, important, typography_reset ),
	// 						'background' => array( $accent_color, 'accent_color' ),
	// 						'color'      => array( $accent_font, 'accent_font' ),
	// 						),
	// 				) );

	hoot_add_css_rule( array(
						'selector'  => '.notice-widget.preset-accent',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'background'   => array( $accent_color, 'accent_color' ),
							'color'        => array( $accent_font, 'accent_font' ),
							),
					) );

	hoot_add_css_rule( array(
						'selector'  => '.wordpress .button-widget.preset-accent',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'border-color' => array( $accent_color, 'accent_color' ),
							'background'   => array( $accent_color, 'accent_color' ),
							'color'        => array( $accent_font, 'accent_font' ),
							),
					) );
	hoot_add_css_rule( array(
						'selector'  => '.wordpress .button-widget.preset-accent:hover',
						'property'  => array(
							// property  => array( value, idtag, important, typography_reset ),
							'background'   => array( $accent_font, 'accent_font' ),
							'color'        => array( $accent_color, 'accent_color' ),
							),
					) );

	hoot_add_css_rule( array(
						'selector'  => '.current-tabhead',
						'property'  => 'border-bottom-color',
						'value'     => $content_bg_color,
					) );

}
endif;