<?php
/**
 * Hoot Customize framework is an extended version of the
 * Customizer Library v1.3.0, Copyright 2010 - 2014, WP Theming http://wptheming.com
 * and is licensed under GPLv2
 *
 * This file is loaded at 'after_setup_theme' hook with 4 priority.
 *
 * @package    Magazine News Byte
 * @subpackage Library Premium
 */

/** Include custom controls **/
foreach ( glob( hoot_data()->premium_libdir . 'customize/control-*.php' ) as $file_path ) {
	include_once( $file_path );
}


/* == interface == */


/**
 * Enqueue scripts to customizer screen
 *
 * @since 3.0.0
 * @return void
 */
function hoot_premium_customize_enqueue_scripts() {

	// Enqueue Styles
	$style_uri = hoot_locate_style( hoot_data()->premium_liburi . 'css/customize.premium' );
	wp_enqueue_style( 'hoot-premium-customize-styles', $style_uri, array(),  hoot_data()->hoot_version );

	// Enqueue Scripts
	$script_uri = hoot_locate_script( hoot_data()->premium_liburi . 'js/customize.premium' );
	wp_enqueue_script( 'hoot-premium-customize-script', $script_uri, array( 'jquery', 'wp-color-picker', 'customize-controls' ), hoot_data()->hoot_version, true );

	// Localize Script
	// @NU
	$data = apply_filters( 'hoot_premium_customize_control_footer_js_data_object', array() );
	if ( is_array( $data ) && !empty( $data ) )
		wp_localize_script( 'hoot-premium-customize-script', 'hoot_customize_data', $data ); // Possibly need to change name `hoot_customize_data` to avoid clash with core theme's library customize data

}
// Load scripts at priority 11 so that Hoot Customizer Custom Controls have loaded their scripts
add_action( 'customize_controls_enqueue_scripts', 'hoot_premium_customize_enqueue_scripts', 11 );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 * @NU
 *
 * @since 3.0.0
 * @return void
 */
function hoot_premium_customize_preview_js() {

	// Note: Use 'customize-preview-premium,js' instead of 'customize-preview.js' else hoot_locate_script() from lite will load file from premium instead of lite
	// This is useful for overriding files, not when both need to be enqueued. (alternative: use file_exists() instead of hoot_locate_script() )
	$script_uri = ( function_exists( 'hoot_locate_script' ) ) ? hoot_locate_script( hoot_data()->premium_incuri . 'admin/js/customize-preview-premium' ) : '';
	if ( $script_uri )
		wp_enqueue_script( 'hoot-customize-preview-premium', $script_uri, array( 'customize-preview' ), hoot_data()->hoot_version, true );

}
// Redundant: Since we add code to /js/customize-preview.js from lite version
// If activated, localize 'hootInlineStyles' to 'hoot-customize-preview-premium' as well.
// add_action( 'customize_preview_init', 'hoot_premium_customize_preview_js' );