<?php
/**
 * Theme Meta Options displayed in admin.
 * Themes should use default 'mainbox' as ID for the main meta options box id for brevity. This is the
 * default id used for 'hoot_get_metaoption()' function.
 *
 * @package    Magazine News Byte
 * @subpackage Theme Premium
 */

/* Hook in to add some additiona css for specific options */
add_action( 'admin_enqueue_scripts', 'magnb_metaoptions_enqueue', 11 );

/**
 * Add some additiona css for specific options
 * This hook is only fired when meta options are being displayed. So checking hook is redundant
 *
 * @since 1.0
 * @param string $hook
 * @return void
 */
function magnb_metaoptions_enqueue( $hook ) {
	if ( $hook == 'post-new.php' || $hook == 'post.php' ) :
		$screen = get_current_screen();
		$post_type = $screen->post_type;
		if ( $post_type == 'page' ) {
			global $post;
			if ( !empty( $post->ID ) && ( $post->ID == get_option( 'page_on_front' ) ) ) {
				echo '<style>
				#hoot-sidebar_type,
				#hoot-sidebar,
				#hoot-home_sidebar,
				#hoot-wooshop_sidebar,
				#hoot-display_loop_meta,
				#hoot-meta_hide_info,
				#hoot-pre_title_content,
				#hoot-pre_title_content_post,
				#hoot-pre_title_content_stretch { display: none !important; }
				</style>';
			} elseif ( !empty( $post->ID ) && ( $post->ID == get_option( 'page_for_posts' ) ) ) {
				echo '<style>
				#hoot-sidebar_type,
				#hoot-sidebar,
				#hoot-fp_sidebar,
				#hoot-wooshop_sidebar,
				#hoot-meta_hide_info { display: none !important; }
				</style>';
			} elseif ( !empty( $post->ID ) && ( $post->ID == get_option( 'woocommerce_shop_page_id' ) ) ) {
				echo '<style>
				#hoot-sidebar_type,
				#hoot-sidebar,
				#hoot-fp_sidebar,
				#hoot-home_sidebar,
				#hoot-meta_hide_info { display: none !important; }
				</style>';
			} else {
				echo '<style>#hoot-fp_sidebar, #hoot-home_sidebar, #hoot-wooshop_sidebar { display: none !important; }</style>';
			}
		}
	endif;
}

/**
 * Defines an array of meta options that will be used to generate the metabox.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * Child themes can modify the meta options array using the 'hoot_metaoptions_array' filter hook.
 *
 * @since 1.0
 * @return void
 */
function magnb_metaoptions() {

	// define a directory path for using image radio buttons
	$imagepath =  hoot_data()->incuri . 'admin/images/';

	$options['page']['mainbox'] =
	$options['post']['mainbox'] = array(
		'title'    => __( 'Page Options', 'magazine-news-byte-premium' ),
		'context'  => 'normal',
		'priority' => 'high',
	);

		$options['page']['mainbox']['options']['sidebar_type'] =
		$options['post']['mainbox']['options']['sidebar_type'] = array(
			'name'    => __( 'Sidebar Layout', 'magazine-news-byte-premium' ),
			'type'    => 'radio',
			'std'     => 'default',
			'options' => array(
				'default' => __('Default layout as selected in Theme Options', 'magazine-news-byte-premium'),
				'custom'  => __('Custom Layout for this page.', 'magazine-news-byte-premium'),
			),
		);

		$options['page']['mainbox']['options']['sidebar'] =
		$options['post']['mainbox']['options']['sidebar'] = array(
			'name'        => __( 'Custom Sidebar Layout for page', 'magazine-news-byte-premium' ),
			'type'        => 'images',
			'std'         => 'wide-right',
			'settings'    => array(
								'condition' => 'sidebar_type',
								'match'     => 'custom',
							),
			'options'     => array(
				'wide-right'         => $imagepath . 'sidebar-wide-right.png',
				'narrow-right'       => $imagepath . 'sidebar-narrow-right.png',
				'wide-left'          => $imagepath . 'sidebar-wide-left.png',
				'narrow-left'        => $imagepath . 'sidebar-narrow-left.png',
				'narrow-left-right'  => $imagepath . 'sidebar-narrow-left-right.png',
				'narrow-left-left'   => $imagepath . 'sidebar-narrow-left-left.png',
				'narrow-right-right' => $imagepath . 'sidebar-narrow-right-right.png',
				'full-width'         => $imagepath . 'sidebar-full.png',
				'none'               => $imagepath . 'sidebar-none.png',
			),
		);

		$options['page']['mainbox']['options']['fp_sidebar'] = array(
			'name'        => __( 'Sidebar Layout', 'magazine-news-byte-premium' ),
			/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
			'desc'        => '<em>' . sprintf( __( 'This option is not available since this page is set as the Front page. Please go to %1$s%3$sAppearance &gt; Customize &gt; Setup &amp; Layout &gt; Sidebar Layout (for Front Page)%4$s%2$s to change the layout for Front Page', 'magazine-news-byte-premium' ), '<a href="' . esc_url( admin_url( 'customize.php?autofocus[control]=sidebar_fp' ) ) . '">', '</a>', '<strong>', '</strong>' ) . '</em>',
			'type'        => 'info',
		);

		$options['page']['mainbox']['options']['home_sidebar'] = array(
			'name'        => __( 'Sidebar Layout', 'magazine-news-byte-premium' ),
			'desc'        => '<em>' . __( "This option is not available since this page is set as the 'Blog' page. Please go to <strong>'Appearance &gt; Customize &gt; Setup &amp; Layout &gt; Sidebar Layout (for Blog)'</strong> to change the layout for Blog/Archive Pages", 'magazine-news-byte-premium' ) . '</em>',
			'type'        => 'info',
		);

		$options['page']['mainbox']['options']['wooshop_sidebar'] = array(
			'name'        => __( 'Sidebar Layout', 'magazine-news-byte-premium' ),
			'desc'        => '<em>' . __( "This option is not available since this page is set as the 'Shop' page. Please go to <strong>'Appearance &gt; Customizer &gt; Woocommerce'</strong> section  to change the layout for Woocommerce Pages", 'magazine-news-byte-premium' ) . '</em>',
			'type'        => 'info',
		);

		$options['page']['mainbox']['options']['display_loop_meta'] =
		$options['post']['mainbox']['options']['display_loop_meta'] = array(
			'name'    => __( 'Title Area', 'magazine-news-byte-premium' ),
			'type'    => 'radio',
			'std'     => 'show',
			'options' => array(
				'show' => __('Display Title Area (default)', 'magazine-news-byte-premium'),
				'hide' => __('Hide Title Area for this page.', 'magazine-news-byte-premium'),
			),
		);

		$options['page']['mainbox']['options']['meta_hide_info'] =
		$options['post']['mainbox']['options']['meta_hide_info'] = array(
			'name'        => __( 'Hide Meta Info', 'magazine-news-byte-premium' ),
			'desc'        => __( 'Hide Meta Info like Author, Date etc. for this page', 'magazine-news-byte-premium' ),
			'type'        => 'checkbox',
			'settings'    => array(
								'condition' => 'display_loop_meta',
								'match'     => 'show',
							),
		);

		$options['page']['mainbox']['options']['pre_title_content'] =
		$options['post']['mainbox']['options']['pre_title_content'] = array(
			'name'     => __( 'Custom Content before Title Area', 'magazine-news-byte-premium' ),
			'desc'     => __('Display some content before the title area.<br />You can add any content like images, slider shortcodes etc. to appear before the Title Area on this page.', 'magazine-news-byte-premium'),
			'type'     => 'textarea',
			'settings' => array( 'rows' => 3, 'containerclass' => 'hoot-merge-nextbox' ),
		);

		$options['page']['mainbox']['options']['pre_title_content_post'] =
		$options['post']['mainbox']['options']['pre_title_content_post'] = array(
			// 'name' => __( 'Display Content after Title Area', 'magazine-news-byte-premium' ),
			'desc' => __( 'Display the above content <strong>next to the Title Area</strong>. (by default it appears <strong>fullwidth at top before title area</strong>)', 'magazine-news-byte-premium' ),
			'type' => 'checkbox',
			'settings' => array( 'containerclass' => 'hoot-merge-nextbox' ),
		);

		$options['page']['mainbox']['options']['pre_title_content_stretch'] =
		$options['post']['mainbox']['options']['pre_title_content_stretch'] = array(
			// 'name' => __( 'Remove Padding from Title Area Content', 'magazine-news-byte-premium' ),
			'desc' => __( 'Stretch the above content area from edge to edge.<br />This is useful if you are adding content like images or sliders, and dont want any padding/margins.', 'magazine-news-byte-premium' ),
			'type' => 'checkbox',
		);

		$options['page']['mainbox']['options']['page_css'] =
		$options['post']['mainbox']['options']['page_css'] = array(
			'name'     => __( 'Custom CSS', 'magazine-news-byte-premium' ),
			'desc'     => __('Custom CSS for this page only', 'magazine-news-byte-premium'),
			'type'     => 'textarea',
			'settings' => array( 'code' => true, 'rows' => 3 ),
		);

	$hoot_metaoptions = Hoot_Metaoptions::get_instance();
	$hoot_metaoptions->add_options( $options );

}

// Add Meta Options
magnb_metaoptions();