<?php
/**
 * Defines customizer premium options
 *
 * This file is loaded at 'after_setup_theme' hook with 10 priority.
 *
 * @package    Magazine News Byte
 * @subpackage Theme Premium
 */

/**
 * Add Premium Theme default colors and fonts
 *
 * @since 1.0
 * @access public
 * @return array
 */
if ( !function_exists( 'magnb_default_premium_style' ) ) :
function magnb_default_premium_style( $defaults ){
	$defaults = array_merge( $defaults, array(
		/* Override Free defaults */
		// 'module_bg_default'          => '#f5f5f5',
		// 'site_background'            => '#ffffff',
		/* Premium defaults */
		// 'site_background_patt'       => 'hoot/images/patterns/4.png',
		// 'site_background_type'       => 'custom',
		// 'site_background_image'      => hoot_data()->template_uri . 'images/background.jpg',
		// 'site_background_size'       => 'cover',
		// 'site_background_repeat'     => 'no-repeat',
		// 'site_background_attachment' => 'fixed',
		'menu_icons_color'           => '#ffffff',
		'topbar_background'          => '#bd2e2e',
		'header_background'          => '#ffffff',
		'logo_background'            => '#bd2e2e',
		'menu_background'            => '#bd2e2e',
		'menu_dropdown_background'   => '#ffffff',
		'below_header_background'    => '#2a2a2a',
		'pageheader_background'      => '#f5f5f5',
		'footer_background'          => '#2a2a2a',
		'topbar_color'               => '#ffffff',
		'font_logo_size'             => '35px',
		'font_logo_face'             => '"Lora", serif',
		'font_logo_style'            => 'uppercase bold',
		'font_logo_color'            => '#000000',
		'font_tagline_size'          => '14px',
		'font_tagline_face'          => '"Roboto", sans-serif',
		'font_tagline_style'         => 'uppercase',
		'font_tagline_color'         => '#444444',
		'font_nav_menu_size'         => '15px',
		'font_nav_menu_face'         => '"Roboto", sans-serif',
		'font_nav_menu_style'        => 'uppercase bold',
		'font_nav_menu_color'        => '#ffffff',
		'font_nav_dropdown_size'     => '14px',
		'font_nav_dropdown_style'    => 'none',
		'font_nav_dropdown_color'    => '#000000',
		'below_header_color'         => '#ffffff',
		'font_body_size'             => '15px',
		'font_body_face'             => '"Roboto", sans-serif',
		'font_body_style'            => 'none',
		'font_body_color'            => '#666666',
		'link_color'                 => '#bd2e2e',
		'link_hover_color'           => '#8e2222',
		'font_h3_size'               => '20px',
		'font_h3_face'               => '"Roboto", sans-serif',
		'font_h3_style'              => 'bold',
		'font_h3_color'              => '#222222',
		'font_h1_size'               => '28px',
		'font_h1_style'              => 'bold',
		'font_h1_color'              => '#222222',
		'font_h2_size'               => '24px',
		'font_h2_style'              => 'bold',
		'font_h2_color'              => '#222222',
		'font_h4_size'               => '18px',
		'font_h4_style'              => 'bold',
		'font_h4_color'              => '#222222',
		'font_h5_size'               => '17px',
		'font_h5_style'              => 'bold',
		'font_h5_color'              => '#222222',
		'font_h6_size'               => '16px',
		'font_h6_style'              => 'bold',
		'font_h6_color'              => '#222222',
		'font_sidebar_heading_size'  => '15px',
		'font_sidebar_heading_face'  => '"Roboto", sans-serif',
		'font_sidebar_heading_style' => 'uppercase',
		// 'font_sidebar_heading_color' => '#ffffff',
		'font_sidebar_size'          => '15px',
		'font_sidebar_style'         => 'none',
		'font_sidebar_color'         => '#666666',
		'font_footer_heading_size'   => '15px',
		'font_footer_heading_face'   => '"Roboto", sans-serif',
		'font_footer_heading_style'  => 'uppercase',
		// 'font_footer_heading_color'  => '#ffffff',
		'font_footer_size'           => '15px',
		'font_footer_style'          => 'none',
		'font_footer_color'          => '#ffffff',
	) );
	return $defaults;
}
endif;
add_filter( 'magnb_default_style', 'magnb_default_premium_style', 5 );

/**
 * Build the Customizer options (panels, sections, settings)
 *
 * Always remember to mention specific priority for non-static options like:
 *     - options being added based on a condition (eg: if woocommerce is active)
 *     - options which may get removed (eg: logo_size, headings_fontface)
 *     - options which may get rearranged (eg: logo_background_type)
 *     This will allow other options inserted with priority to be inserted at
 *     their intended place.
 *
 * @since 1.0
 * @access public
 * @return array
 */
if ( !function_exists( 'magnb_customizer_premium_options' ) ) :
function magnb_customizer_premium_options() {

	// Stores all the settings to be added
	$settings = array();

	// Stores all the sections to be added
	$sections = array();

	// Stores all the panels to be added
	$panels = array();

	// Theme default colors and fonts
	extract( magnb_default_style() );

	// Directory path for radioimage buttons
	$imagepath =  hoot_data()->incuri . 'admin/images/';

	/*** Add Options (Panels, Sections, Settings) ***/

	/** Section **/

	$section = 'title_tagline';

	$settings['disable_lightbox'] = array(
		'label'       => esc_html__( 'Disable Lightbox', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'checkbox',
		'priority'    => '105',
		'description' => array(
			'type' => 'yellow',
			/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
			'text' => sprintf( esc_html__('Check this if you do not want image links to open in a lightbox throughout your site.%1$sUsers can always add the %2$sno-lightbox%3$s class to links to stop them from opening in lightbox. Example:%1$s%2$s&lt;a href="image.png" class="no-lightbox"&gt;Content&lt;/a&gt;%3$s', 'magazine-news-byte-premium'), '<hr>', '<code>', '</code>' ),
		),
	);

	$settings['disable_goto_top'] = array(
		'label'       => esc_html__( "Disable 'Goto Top' Button", 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'checkbox',
		'priority'    => '105',
		'description' => esc_html__( 'Check this to hide "Top" button (bottom right of screen) when a user scrolls down the page.', 'magazine-news-byte-premium' ),
	);

	$settings['scrollpadding'] = array(
		'label'       => esc_html__( 'Custom padding for scrollpoints', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'text',
		'default'     => '120',
		'priority'    => '105',
		'description' => esc_html__( 'This is the distance from the top of the screen when the page scrolls down to a scrollpoint.', 'magazine-news-byte-premium' ),
		'input_attrs' => array(
			'placeholder' => esc_html__( 'default: 120', 'magazine-news-byte-premium' ),
		),
	);

	/** Section **/

	$section = 'header';

	$settings['disable_sticky_header'] = array(
		'label'       => esc_html__( 'Disable Sticky Header', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'checkbox',
		'priority'    => '105',
		'description' => esc_html__( 'Check this if you do not want to display a fixed Header at top when a user scrolls down the page.', 'magazine-news-byte-premium' ),
	);

	/** Section **/

	$section = 'colors';

	$settings['background'] = array(
		'label'       => esc_html__( 'Site Background', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'betterbackground',
		'priority'    => '395',
		'default'     => array(
			'color'      => $site_background,
			// 'type'       => $site_background_type,
			// 'image'      => $site_background_image,
			// 'size'       => $site_background_size,
			// 'repeat'     => $site_background_repeat,
			// 'attachment' => $site_background_attachment,
			// 'pattern'    => $site_background_patt,
		),
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'description' => sprintf( esc_html__( 'This background is more prominently visible when %1$sSite Layout%2$s option is set to %1$s"Boxed"%2$s in the %1$s"Setup &amp; Layout"%2$s section.', 'magazine-news-byte-premium' ), '<strong>', '</strong>' ),
	);

	$settings['box_background_color'] = array(
		'label'       => esc_html__( 'Content Background Color', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'color',
		'priority'    => '396', // Mention priority to override previous priority set in lite version
		'default'     => $box_background,
		'transport' => 'postMessage',
	); // Overriding non premium setting

	$settings['topbar_background_type'] = array(
		'label'       => esc_html__( 'Topbar Background', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'radio',
		'choices'     => array(
			'transparent' => esc_html__('None', 'magazine-news-byte-premium'),
			'background'  => esc_html__('Custom Color', 'magazine-news-byte-premium'),
		),
		'default'     => 'background',
	);

	$settings['topbar_background'] = array(
		'label'           => esc_html__( 'Topbar Background Color', 'magazine-news-byte-premium' ),
		'section'         => $section,
		'type'            => 'color',
		'default'         => $topbar_background,
		'active_callback' => 'magnb_callback_topbar_background',
	);

	$settings['header_background_type'] = array(
		'label'       => esc_html__( 'Site Header', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'radio',
		'choices'     => array(
			'transparent' => esc_html__('None (Transparent)', 'magazine-news-byte-premium'),
			'background'  => esc_html__('Background', 'magazine-news-byte-premium'),
		),
		'default'     => 'transparent',
		'description' => esc_html__( 'This is the Site Header containing Logo and Menu', 'magazine-news-byte-premium' ),
	);

	$settings['header_background'] = array(
		'label'           => esc_html__( "Site Header (Select 'Background' above)", 'magazine-news-byte-premium' ),
		'section'         => $section,
		'type'        => 'betterbackground',
		'default'     => array(
			'color'      => $header_background,
		),
		// 'active_callback' => 'magnb_callback_header_background', // Doesnt work for betterbackground
	);

	$settings['logo_background_type'] = array(
		'label'       => esc_html__( 'Logo Background', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'radio',
		'priority'    => '545', // Mention priority to override previous priority set in lite version
		'choices'     => array(
			'transparent' => esc_html__( 'None', 'magazine-news-byte-premium' ),
			'accent'      => esc_html__( 'Accent Color', 'magazine-news-byte-premium' ),
			'background'  => esc_html__( 'Custom Color', 'magazine-news-byte-premium' ),
		),
		'default'     => 'transparent',
	); // Overriding non premium setting

	$settings['logo_background'] = array(
		'label'           => esc_html__( 'Logo Background Custom Color', 'magazine-news-byte-premium' ),
		'section'         => $section,
		'type'            => 'color',
		'priority'        => '545', // Mention priority to keep it along with radio above
		'default'         => $logo_background,
		'active_callback' => 'magnb_callback_logo_background',
	);

	$settings['menu_background_type'] = array(
		'label'       => esc_html__( 'Menu Background', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'radio',
		'choices'     => array(
			'transparent' => esc_html__('None', 'magazine-news-byte-premium'),
			'background'  => esc_html__('Custom Color', 'magazine-news-byte-premium'),
		),
		'default'     => 'background',
		// 'description' => esc_html__( 'This is applied only to secondary menu', 'magazine-news-byte-premium' ),
	);

	$settings['menu_background'] = array(
		'label'           => esc_html__( 'Menu Background Color', 'magazine-news-byte-premium' ),
		'section'         => $section,
		'type'            => 'color',
		'default'         => $menu_background,
		'active_callback' => 'magnb_callback_menu_background',
	);

	$settings['menu_icons_color'] = array(
		'label'       => esc_html__( 'Header Nav Menu - Icon Color', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'color',
		'default'     => $menu_icons_color,
		/* Translators: 1 is the link start markup, 2 is link markup end */
		'description' => sprintf( esc_html__('You can add icons to your navigation menu from the %1$sMenu Management screen%2$s.', 'magazine-news-byte-premium'), '<a href="' . esc_url( admin_url('nav-menus.php') ) . '" target="_blank">', '</a>' ),
	);

	$settings['menu_dropdown_background'] = array(
		'label'       => esc_html__( 'Menu Dropdown Background / Mobile Menu Background', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'color',
		'default'     => $menu_dropdown_background,
	);

	$settings['below_header_background'] = array(
		'label'           => esc_html__( 'Below Header Widget Area Background Color', 'magazine-news-byte-premium' ),
		'section'         => $section,
		'type'            => 'color',
		'default'         => $below_header_background,
	);

	$settings['pageheader_background'] = array(
		'label'       => esc_html__( 'Page Title Header Background', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'color',
		'default'     => $pageheader_background,
		'description' => esc_html__( 'This is the Page Header area at top (below Logo and Menu) containing Page/Post Title and Meta details like author, categories etc.', 'magazine-news-byte-premium' ),
	);

	$settings['pageheader_background_location'] = array(
		'label'       => esc_html__( 'Apply Background only when Page Header is:', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'radioimage',
		'choices'     => array(
			'stretch'   => $imagepath . 'pageheader-stretch.png',
			'incontent' => $imagepath . 'pageheader-incontent.png',
			'both'      => $imagepath . 'pageheader-both.png',
			'none'      => $imagepath . 'pageheader-none.png',
		),
		'default'     => 'stretch',
	);

	$settings['footer_background'] = array(
		'label'       => esc_html__( 'Footer Background', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'betterbackground',
		'default'     => array(
			'color'      => $footer_background,
		),
	);

	/** Section **/

	$section = 'typography';

	$settings['topbar_color'] = array(
		'label'       => esc_html__( 'Topbar Font', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'color',
		'default'     => $topbar_color,
	);

	$settings['font_logo'] = array(
		'label'       => esc_html__( 'Logo Text', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_logo_size,
			'face'  => $font_logo_face,
			'style' => $font_logo_style,
			'color' => $font_logo_color,
		),
		/* Translators: 1 is the link start markup, 2 is link markup end */
		'description' => sprintf( esc_html__('For "Plain Text" Logo option. Site Title can be changed via %1$sWordPress Settings%2$s.', 'magazine-news-byte-premium'), '<a href="' . esc_url( admin_url('options-general.php') ) . '" target="_blank">', '</a>' ),
	);

	$settings['font_tagline'] = array(
		'label'       => esc_html__( 'Logo Tagline', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_tagline_size,
			'face'  => $font_tagline_face,
			'style' => $font_tagline_style,
			'color' => $font_tagline_color,
		),
		/* Translators: 1 is the link start markup, 2 is link markup end */
		'description' => sprintf( esc_html__('For "Plain Text" Logo option. Site Tagline can be changed via %1$sWordPress Settings%2$s.', 'magazine-news-byte-premium'), '<a href="' . esc_url( admin_url('options-general.php') ) . '" target="_blank">', '</a>' ),
	);

	$settings['font_nav_menu'] = array(
		'label'       => esc_html__( 'Menu Font', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_nav_menu_size,
			'face'  => $font_nav_menu_face,
			'style' => $font_nav_menu_style,
			'color' => $font_nav_menu_color,
		),
	);

	$settings['font_nav_dropdown'] = array(
		'label'       => esc_html__( 'Menu Dropdown Font / Mobile Menu Font', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_nav_dropdown_size,
			'style' => $font_nav_dropdown_style,
			'color' => $font_nav_dropdown_color,
		),
		'options'     => array( 'size', 'style', 'color' ),
	);

	$settings['below_header_color'] = array(
		'label'       => esc_html__( 'Below Header Widget Area Font', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'color',
		'default'     => $below_header_color,
	);

	$settings['font_body'] = array(
		'label'       => esc_html__( 'Body Content', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_body_size,
			'face'  => $font_body_face,
			'style' => $font_body_style,
			'color' => $font_body_color,
		),
	);

	$settings['link_color'] = array(
		'label'       => esc_html__( 'Link Color', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'color',
		'default'     => $link_color,
	);

	$settings['link_hover_color'] = array(
		'label'       => esc_html__( 'Link Hover Color', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'color',
		'default'     => $link_hover_color,
	);

	$settings['font_h3'] = array(
		'label'       => esc_html__( 'General Headings (Heading 3)', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_h3_size,
			'face'  => $font_h3_face,
			'style' => $font_h3_style,
			'color' => $font_h3_color,
		),
	);

	$settings['font_h1'] = array(
		'label'       => esc_html__( 'Heading 1', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_h1_size,
			'style' => $font_h1_style,
			'color' => $font_h1_color,
		),
		'options'     => array( 'size', 'style', 'color' ),
	);

	$settings['font_h2'] = array(
		'label'       => esc_html__( 'Heading 2', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_h2_size,
			'style' => $font_h2_style,
			'color' => $font_h2_color,
		),
		'options'     => array( 'size', 'style', 'color' ),
	);

	$settings['font_h4'] = array(
		'label'       => esc_html__( 'Heading 4', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_h4_size,
			'style' => $font_h4_style,
			'color' => $font_h4_color,
		),
		'options'     => array( 'size', 'style', 'color' ),
	);

	$settings['font_h5'] = array(
		'label'       => esc_html__( 'Heading 5', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_h5_size,
			'style' => $font_h5_style,
			'color' => $font_h5_color,
		),
		'options'     => array( 'size', 'style', 'color' ),
	);

	$settings['font_h6'] = array(
		'label'       => esc_html__( 'Heading 6', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_h6_size,
			'style' => $font_h6_style,
			'color' => $font_h6_color,
		),
		'options'     => array( 'size', 'style', 'color' ),
	);

	$settings['font_sidebar_heading'] = array(
		'label'       => esc_html__( 'Sidebar Widget Heading', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_sidebar_heading_size,
			'face'  => $font_sidebar_heading_face,
			'style' => $font_sidebar_heading_style,
			// 'color' => $font_sidebar_heading_color,
		),
		'options'     => array( 'size', 'face', 'style' ),
	);

	$settings['font_sidebar'] = array(
		'label'       => esc_html__( 'Sidebar Widget Text', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_sidebar_size,
			'style' => $font_sidebar_style,
			'color' => $font_sidebar_color,
		),
		'options'     => array( 'size', 'style', 'color' ),
	);

	$settings['font_footer_heading'] = array(
		'label'       => esc_html__( 'Footer Widget Heading', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_footer_heading_size,
			'face'  => $font_footer_heading_face,
			'style' => $font_footer_heading_style,
			// 'color' => $font_footer_heading_color,
		),
		'options'     => array( 'size', 'face', 'style' ),
	);

	$settings['font_footer'] = array(
		'label'       => esc_html__( 'Footer Widget Text', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'typography',
		'default'     => array(
			'size'  => $font_footer_size,
			'style' => $font_footer_style,
			'color' => $font_footer_color,
		),
		'options'     => array( 'size', 'style', 'color' ),
	);

	/** Section **/

	// $section = 'archives';

	// $settings['archive_type'] = array(
	// 	'label'       => esc_html__( 'Archive (Blog) Layout', 'magazine-news-byte-premium' ),
	// 	'section'     => $section,
	// 	'type'        => 'radioimage',
	// 	// 'priority'    => '745',
	// 	'choices'     => array(
	// 		'big'          => $imagepath . 'archive-big.png',
	// 		'medium'       => $imagepath . 'archive-medium.png',
	// 		'small'        => $imagepath . 'archive-small.png',
	// 		'mixed-medium' => $imagepath . 'archive-mixed-medium.png',
	// 		'mixed-small'  => $imagepath . 'archive-mixed-small.png',
	// 		'block2'       => $imagepath . 'archive-block2.png',
	// 		'block3'       => $imagepath . 'archive-block3.png',
	// 		'mixed-block2' => $imagepath . 'archive-mixed-block2.png',
	// 		'mixed-block3' => $imagepath . 'archive-mixed-block3.png',
	// 		'mosaic2'      => $imagepath . 'archive-mosaic2.png',
	// 		'mosaic3'      => $imagepath . 'archive-mosaic3.png',
	// 		'mosaic4'      => $imagepath . 'archive-mosaic4.png',
	// 	),
	// 	'default'     => 'big',
	// 	/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
	// 	'description' => sprintf( esc_html__('Set the post style for archive pages like your Blog.%1$s* Big Image%2$s* Medium Image (Non Cropped)%2$s* Small Image (Cropped)%2$s* Mosaic 2 column%2$s* Mosaic 3 column', 'magazine-news-byte-premium'), '<hr>', '<br />' ),
	// );

	/** Section **/

	$section = 'page_404';

	$sections[ $section ] = array(
		'title'       => esc_html__( '404 Page', 'magazine-news-byte-premium' ),
		'priority'    => '42',
	);

	$settings['404_page'] = array(
		'label'       => esc_html__( '404 (Not Found) Page', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'radio',
		'choices'     => array(
			'default' => esc_html__( "Theme's default 404 page", 'magazine-news-byte-premium' ),
			'custom' => esc_html__( 'Custom 404 page', 'magazine-news-byte-premium' ),
		),
		'default'     => 'default',
	);

	$settings['404_custom_page'] = array(
		'label'           => esc_html__( 'Custom 404 Page Content', 'magazine-news-byte-premium' ),
		'section'         => $section,
		'type'            => 'select',
		'choices'         => Hoot_List::pages(),
		'description'     => esc_html__( 'Select a custom page to be used as content for the 404 Not Found page', 'magazine-news-byte-premium' ),
		'active_callback' => 'magnb_callback_404_custom_page',
	);

	/** Section **/

	$section = 'code';

	$sections[ $section ] = array(
		'title'       => esc_html__( 'Custom Code', 'magazine-news-byte-premium' ),
	);

	$settings['custom_js'] = array(
		'label'       => esc_html__( 'Custom Javascript (Google Analytics Code)', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'textarea',
		'description' => esc_html__( 'You can add custom JS snippets (like Google Analytics code) here. These settings will stay unaffected by Theme updates', 'magazine-news-byte-premium' ),
		'sanitize_callback' => 'magnb_sanitize_textarea_allowscript',
	);

	$settings['custom_js_inheader'] = array(
		'label'       => esc_html__( 'Include Custom Javascript in Header', 'magazine-news-byte-premium' ),
		'sublabel'    => esc_html__( 'By default, javascript is added in footer.', 'magazine-news-byte-premium' ),
		'section'     => $section,
		'type'        => 'checkbox',
		/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
		'description' => sprintf( esc_html__( 'Check this if you want to include it in %1$s&lt;head&gt;%2$s tag.%3$sThis can be useful for adding scripts like %4$sGoogle Analytics%5$s code. Do note that adding long javascript in header increases page load time.', 'magazine-news-byte-premium' ), '<code>', '</code>', '<br />', '<strong>', '</strong>' ),
	);


	/*** Return Options Array ***/
	return apply_filters( 'magnb_customizer_premium_options', array(
		'settings' => $settings,
		'sections' => $sections,
		'panels'   => $panels,
	) );

}
endif;

/**
 * Add Options (settings, sections and panels) to Hoot_Customize class options object
 *
 * @since 1.0
 * @access public
 * @return void
 */
if ( !function_exists( 'magnb_add_customizer_premium_options' ) ) :
function magnb_add_customizer_premium_options() {

	$hoot_customize = Hoot_Customize::get_instance();

	// Modify Lite version Options

	$hoot_customize->remove_settings( 'logo_size' );
	$hoot_customize->remove_settings( array( 'logo_fontface', 'logo_fontface_style' ) );
	$hoot_customize->remove_settings( array( 'headings_fontface', 'headings_fontface_style' ) );
	// $hoot_customize->remove_settings( 'logo_background_type' ); // Redundant as $hoot_customize->add_options merges the settings
	// $hoot_customize->remove_settings( 'box_background_color' ); // Redundant as $hoot_customize->add_options merges the settings

	// Add Options
	$options = magnb_customizer_premium_options();
	$hoot_customize->add_options( array(
		'settings' => $options['settings'],
		'sections' => $options['sections'],
		'panels' => $options['panels'],
		) );

}
endif;
add_action( 'init', 'magnb_add_customizer_premium_options', 0 ); // cannot hook into 'after_setup_theme' as this hook is already being executed (this file is loaded at after_setup_theme @priority 10) (hooking into same hook from within while hook is being executed leads to undesirable effects as $GLOBALS[$wp_filter]['after_setup_theme'] has already been ksorted)
// Hence, we hook into 'init' @priority 0, so that settings array gets populated before 'widgets_init' action ( which itself is hooked to 'init' at priority 1 ) for creating widget areas ( settings array is needed for creating defaults when user value has not been stored )
// Since this file is loaded after lite version, magnb_add_customizer_premium_options() will execute after hoot_add_customizer_options() even if we set same priority 0 [can be added at later priority to ensure loading after lite version settings as premium does not contain settings needed for registering widget areas during widgets_init hook]

/**
 * Modify default WordPress Settings Sections and Panels
 *
 * @since 1.0
 * @param object $wp_customize
 * @return void
 */
function magnb_premium_modify_default_customizer_options( $wp_customize ) {

	if ( function_exists( 'wp_get_custom_css' ) )
		$wp_customize->get_control( 'custom_css' )->section = 'code';
	if ( class_exists( 'Jetpack' ) && Jetpack::is_module_active( 'custom-css' ) ) {
		if ( !empty( $wp_customize->get_control( 'wpcom_custom_css_content_width_control' )->section ) )
			$wp_customize->get_control( 'wpcom_custom_css_content_width_control' )->section = 'code';
		if ( !empty( $wp_customize->get_control( 'jetpack_css_mode_control' )->section ) )
			$wp_customize->get_control( 'jetpack_css_mode_control' )->section = 'code';
		if ( !empty( $wp_customize->get_control( 'jetpack_css_preprocessors_control' )->section ) )
			$wp_customize->get_control( 'jetpack_css_preprocessors_control' )->section = 'code';
	}

}
add_action( 'customize_register', 'magnb_premium_modify_default_customizer_options', 100 );

/**
 * Modify Options array directly
 *
 * @since 1.0
 * @access public
 * @return void
 */
function magnb_modify_customizer_options( $options ) {

	// Directory path for radioimage buttons
	$imagepath =  hoot_data()->incuri . 'admin/images/';

	$options['sections']['colors']['description'] = '';
	// $options['sections']['backgrounds']['description'] = ''; // Redundant as Backgrounds section is not in lite anymore
	$options['sections']['typography']['description'] = '';
	$options['settings']['archive_type']['choices'] = array(
			'big'          => $imagepath . 'archive-big.png',
			'medium'       => $imagepath . 'archive-medium.png',
			'small'        => $imagepath . 'archive-small.png',
			'mixed-medium' => $imagepath . 'archive-mixed-medium.png',
			'mixed-small'  => $imagepath . 'archive-mixed-small.png',
			'block2'       => $imagepath . 'archive-block2.png',
			'block3'       => $imagepath . 'archive-block3.png',
			'mixed-block2' => $imagepath . 'archive-mixed-block2.png',
			'mixed-block3' => $imagepath . 'archive-mixed-block3.png',
			'mosaic2'      => $imagepath . 'archive-mosaic2.png',
			'mosaic3'      => $imagepath . 'archive-mosaic3.png',
			'mosaic4'      => $imagepath . 'archive-mosaic4.png',
		);
	/* Translators: The %s are placeholders for HTML, so the order can't be changed. */
	$options['settings']['archive_type']['description'] = sprintf( esc_html__('Set the post style for archive pages like your Blog.%1$s* Big Image%2$s* Medium Image (Non Cropped)%2$s* Small Image (Cropped)%2$s* 2 Column Blocks %2$s* 3 Column Blocks%2$s* Mosaic 2 column%2$s* Mosaic 3 column', 'magazine-news-byte-premium'), '<hr>', '<br />' );

	return $options;
}
add_filter( 'magnb_customizer_options', 'magnb_modify_customizer_options', 9 );

/**
 * Modify labels for $logofont
 *
 * @since 1.0
 * @access public
 * @return void
 */
// function magnb_modify_options_logofont( $logofont ) {
// 	return array(
// 		'heading'  => esc_html__( "Logo Font (set in 'Typography' section)", 'magazine-news-byte-premium' ),
// 		'heading2' => esc_html__( "Heading Font (set in 'Typography' section)", 'magazine-news-byte-premium' ),
// 		'standard' => esc_html__( "Standard Body Font", 'magazine-news-byte-premium' ),
// 		);
// }
// add_filter( 'magnb_options_logofont', 'magnb_modify_options_logofont' );

/**
 * Add theme specific option specific css
 *
 * @since 1.0
 * @access public
 * @return void
 */
function magnb_customizer_inlinecss() {
	echo '<style>' . '#customize-control-header_background_type,#customize-control-pageheader_background{margin-bottom:0;padding-bottom:5px}#customize-control-header_background_type+.hoot-customize-control-betterbackgroundstart .customize-control-title,#customize-control-pageheader_background_location .customize-control-title{font-size:12px}#customize-control-logo_background,#customize-control-menu_background,#customize-control-topbar_background{margin-top:-15px}#customize-control-logo_background .customize-control-title,#customize-control-menu_background .customize-control-title,#customize-control-topbar_background .customize-control-title{font-size:12px}' . '</style>';
}
add_action( 'customize_controls_print_styles', 'magnb_customizer_inlinecss' );

/**
 * Callback Functions for customizer settings
 */

function magnb_callback_topbar_background( $control ) {
	$selector = $control->manager->get_setting('topbar_background_type')->value();
	return ( $selector == 'background' ) ? true : false;
}
// function magnb_callback_header_background( $control ) {
// 	$selector = $control->manager->get_setting('header_background_type')->value();
// 	return ( $selector == 'background' ) ? true : false;
// }
function magnb_callback_logo_background( $control ) {
	$selector = $control->manager->get_setting('logo_background_type')->value();
	return ( $selector == 'background' ) ? true : false;
}
function magnb_callback_menu_background( $control ) {
	$selector = $control->manager->get_setting('menu_background_type')->value();
	return ( $selector == 'background' ) ? true : false;
}
function magnb_callback_404_custom_page( $control ) {
	$selector = $control->manager->get_setting('404_page')->value();
	return ( $selector == 'custom' ) ? true : false;
}

/**
 * Specific Sanitization Functions for customizer settings
 * See specific settings above for more details.
 */
function magnb_sanitize_textarea_allowscript( $value ) {
	global $allowedposttags;
	// Allow javascript to let users ad code for ads etc.
	$allow = array_merge( $allowedposttags, array(
		'script' => array( 'async' => true, 'charset' => true, 'defer' => true, 'src' => true, 'type' => true ),
	) );
	return wp_kses( $value , $allow );
}